/**
 * Background service worker for Cite Linker Pro
 * Handles keyboard commands and extension lifecycle
 */

// Simple background script for testing
chrome.runtime.onInstalled.addListener(() => {
  console.log('Cite Linker Pro installed');
});

// Handle keyboard commands
chrome.commands.onCommand.addListener((command) => {
  if (command === 'toggle-extension') {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      if (tabs[0]) {
        chrome.tabs.sendMessage(tabs[0].id, {
          type: 'TOGGLE_EXTENSION'
        }).catch(() => {
          console.log('Content script not ready');
        });
      }
    });
  }
});

// Handle messages from content script
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'LOG_ERROR') {
    console.error('Content script error:', message.error);
    sendResponse({ success: true });
  }
});